(function () {
    var app = angular.module('company', []);

    app.directive('company', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/company.html',
            scope: {},
            controller: function ($rootScope, $scope) {
                let ctrl = this;
                $scope.GetLocalized = Helpers.GetLocalized;
                ctrl.tab = 'company';
                originalName = $rootScope.settings.companyName;

                Helpers.RootScopeWatchAndDestroy($scope, 'settings.balance', () => {
                    ctrl.buildings = Buildings.map(x => {
                        let result = Helpers.Clone(x);
                        result.available = $rootScope.settings.balance >= result.price
                            && $rootScope.activeBuilding.workstations < result.workstations;
                        result.isActive = $rootScope.settings.office.buildingName == result.name;
                        return result;
                    });
                });

                ctrl.rentBuilding = building => {
                    $rootScope.confirm(Helpers.GetLocalized('are_you_sure'), Helpers.GetLocalized('confirm_upgrade_building'), () => {
                        $rootScope.safeBuy(() => {
                            let moneySpent = 0;

                            // Remove workstations
                            $rootScope.settings.office.workstations.forEach(x => {
                                let workstationType = Database.workstationTypes.find(y => y.tier == x.tier);
                                moneySpent += workstationType.price;
                                Helpers.RemoveEmployeeFromWorkstation(x);
                            });
                            $rootScope.settings.office.workstations = [];

                            // Remove items
                            moneySpent += _.sum($rootScope.settings.office.items.map(x => x.item.price));
                            $rootScope.settings.office.items = [];

                            $rootScope.settings.office.buildingName = building.name;

                            $rootScope.addTransaction(Helpers.GetLocalized('transaction_money_returned'), moneySpent);
                            $rootScope.settings.balance += moneySpent;
                        }, building.price, Helpers.GetLocalized('office_upfront_payment'));
                    });
                };

                Helpers.MovePropToIsolatedScope($rootScope, $scope, 'companyTier');
                Helpers.MovePropToIsolatedScope($rootScope, $scope, 'tierInfo');
                Helpers.MovePropToIsolatedScope($rootScope, $scope, 'settings');

                $scope.$on('$destroy', () => {
                    if($rootScope.settings.companyName.length == 0) {
                        $rootScope.settings.companyName = originalName;
                    }
                });

                ctrl.employeeCount = Helpers.GetAllEmployees().length;
                ctrl.workstationCount = $rootScope.settings.office.workstations.length;
                ctrl.contractsCompleted = $rootScope.settings.contracts.filter(x => x.completed).length;

                Helpers.RootScopeWatchCollectionAndDestroy($scope, 'settings.activatedBenefits', () => loadBenefits());

                let loadBenefits = () => {
                    let activatedBenefits = $rootScope.settings.activatedBenefits;

                    ctrl.benefits = Database.benefits.map(benefit => {
                        let result = Helpers.Clone(benefit, true);
                        result.active = activatedBenefits.includes(benefit.id);
                        result.price = Helpers.CalculateBenefitCost(benefit);
                        return result;
                    });
                    ctrl.activatedBenefits = activatedBenefits.map(benefitId => Database.benefits.find(y => y.id == benefitId));
                    ctrl.wer = Helpers.CalculateWer();
                };

                ctrl.clickBenefit = benefit => {
                    if ($rootScope.companyTier >= benefit.tier) {
                        if ($rootScope.settings.activatedBenefits.includes(benefit.id)) {
                            _.remove($rootScope.settings.activatedBenefits, x => x == benefit.id);
                        } else {
                            $rootScope.settings.activatedBenefits.push(benefit.id);
                        }
                    }
                };

                ctrl.showUnlocks = () => {
                    $rootScope.settings.tierReport = $rootScope.companyTier;
                };
            },
            controllerAs: 'ctrl'
        };
    });
})();
